<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<xsl:output indent="yes" method="html" encoding="iso-8859-1" omit-xml-declaration="yes"/>

<xsl:template match="/Jornal"> 
	<html>
		 <body>
			<font face="Verdana" size="2">
			<a name="inicio"/>
	  			<xsl:apply-templates select="cabecalho" />
	  		<!--<hr /> -->
				  <xsl:apply-templates select="corpo/seccao" /> 
	  		<!--<hr /> 
				  <xsl:apply-templates select="fecho" /> -->
			  <hr /> 
	  		</font>
		  </body>
	  </html>
</xsl:template> 

<!--  Cabeçalho do Jornal    --> 
<xsl:template match="cabecalho">
	<h1>
		<a name="cabecalho"/>
		<xsl:value-of select="nome"/>
	</h1>
		<p><i><xsl:value-of select="data"/></i></p>	
		<p><i><xsl:value-of select="time"/></i></p>	
		<p><xsl:apply-templates select="directores/director"/></p>	
	<hr>
		<h2> <a name="ind-geral">Noticias</a> </h2>	
		<a name="destaques"/>
		<h3><a name="ind-geral">Destaques</a></h3>
		 <xsl:apply-templates mode="ind-geral" select="/Jornal/corpo/destaques" /> 
		 <xsl:call-template name="std_space"/>
		<h3>
			<a name="seccoes"/>
			<a name="ind-seccoes">Secções</a>
			<xsl:apply-templates mode="ind-geral" select="/Jornal/corpo/seccao"/> 
			<hr/>
			<xsl:apply-templates mode="ind-geral" select="/jornal/corpo/seccao/artigo"/>

		</h3>
	</hr>
</xsl:template> 

<!-- Geração do índice-->
	<!-- nome da seccão e  titulos das secções-->
	<xsl:template match="seccao" mode="ind-geral">
		<a href="#{generate-id()}">
			<h3>
				<xsl:value-of select="nome"/>
			</h3>
		</a>
		<xsl:apply-templates mode="ind-geral" select="artigo"/>
	</xsl:template>
	
	<!-- indice dos titulos e resumos dos destaques -->
	<xsl:template match="destaques" mode="ind-geral">
		<a href="#{generate-id()}">
			<h5>
				<li><xsl:value-of select="titulo"/></li>
			</h5>
		</a>
		<xsl:apply-templates mode="ind-geral" select="resumo"/>
	</xsl:template>	
	
	<!-- indice dos titulos dos artigos -->
	<xsl:template match="artigo" mode="ind-geral">
			<a href="#{generate-id()}">
				<h5><li><xsl:value-of select="titulo"/></li></h5>
			</a>
	</xsl:template>
	

	<!-- leitura dos resumos-->
	<xsl:template match="resumo">
		<xsl:value-of select="paragrafo/."/>	
	</xsl:template> 

	<!-- Leitura dos artigos-->
	<xsl:template match="artigo">
		<h5>
			<a name="{generate-id()}">
				<xsl:value-of select="titulo"/>
			</a>
		</h5>
		<h6><xsl:value-of select="subtitulo"></xsl:value-of></h6>
		<h6><xsl:value-of select="data"></xsl:value-of></h6>
		<!--<xsl:if test="figuras/figura/@path">
			<img src="{figuras/figura/@path}" alt=""/>
			<xsl:value-of select="figuras/legenda"/>
		</xsl:if>-->
		<h5>
			<i> <xsl:value-of select="resumo"/> </i>
		</h5>
		<!--<p>
			<xsl:apply-templates/>
		</p>-->
		<!--<table>  não está a entrar aqui
			<tbody>
				<xsl:for-each select="autores/autor/nome">
					<tr><td><xsl:value-of select="nome"/></td>
					<td><xsl:value-of select="email"/></td></tr>
					<xsl:apply-templates select="autores/autor"/>
				</xsl:for-each>
			</tbody>
	 	</table>-->
	 	<xsl:for-each select="autores/autor/nome">
				<!--<tr><td><xsl:value-of select="nome"/></td>
				<td><xsl:value-of select="email"/></td></tr>-->
				<xsl:apply-templates select="autores/autor"/>
		</xsl:for-each>
	 	<p>
			<xsl:apply-templates select="corpo/paragrafo"/>
		</p>
		<address>
		<center>
		 <table width="100%">
			<tbody>
				<tr>
					<td align="left">  <font size="1">| <a href="#{generate-id(preceding-sibling::Artigo[1])}">Artigo Anterior</a> </font>|</td>
					<td align="center"><xsl:call-template name="menu"/></td>
					<td align="right"> <font size="1">|  <a href="#{generate-id(following-sibling::Artigo[1])}">Artigo Seguinte</a></font>|</td>
				</tr>
			</tbody>
		</table>
		</center>
		<hr/>
		</address>
	</xsl:template>

	<!-- ###  Leitura dos directores  ### -->
	<xsl:template match="director">
		<h4>Director</h4>
		<xsl:call-template name="Pessoa"/>
	</xsl:template>
	
	<xsl:template match="autor">
		<!--<xsl:call-template name="Pessoa"/>-->
		<xsl:apply-templates select="Pessoa"/>
	</xsl:template>


	<!-- ### Leitura da informação da pessoa ####-->
	<xsl:template name="Pessoa">
		<xsl:value-of select="nome"/>
		<xsl:text/>
		<xsl:value-of select="sobrenome"/>
		<br/>
		<small>
			<xsl:variable name="email" select="email"/>
			<a href="mailto:{$email}">
				<xsl:value-of select="email"/>
			</a>
			<xsl:text>  -  </xsl:text>
			<xsl:variable name="link" select="homepage"/>
			<a href="{$link}">
				<xsl:value-of select="homepage"/>
			</a>
		</small>
		<br/>
		<small>
			<center>
				<xsl:value-of select="copyright"/>
			</center>
		</small>
		<br/>
	</xsl:template>
	
	<xsl:template match="paragrafo">
		<p/>
			<xsl:value-of select="."/>
			<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="figuras">
		<center>
			<xsl:variable name="nome" select="legenda"/>
			<xsl:variable name="link" select="{figuras/figura/@path}"/>
			<img src="{$link}" alt="{$nome}" border="0" title="{$nome}"/>
			<br/>
			<br/>
			<small>
				<xsl:value-of select="legenda"/>
			</small>
		</center>
	</xsl:template>

<!--<xsl:template match="figura">
	<img src="{figura/@path}" alt=""/>
	<xsl:value-of select="legenda"/>	
</xsl:template> -->


	<xsl:template match="RefBib">
		<xsl:variable name="bib" select="."/>
		[<a href="#{text()}">
			<xsl:apply-templates/>
		</a>]	
	</xsl:template>

 <!-- ### barra para saltar entre items ### -->
<xsl:template name="menu">
	<font size="1">|
		<a href="#inicio">Início</a>|
		<a href="#destaques">Destaques</a>|
		<a href="#seccoes">Secções</a>|
		<a href="#fecho">Fecho</a>|
	</font>
</xsl:template>

 <!-- ### espaçamento  ### -->
<xsl:template name="std_space">
	<br/>
	<br/>
	<br/>
	<br/>
	<br/>
	<br/>
</xsl:template>


</xsl:stylesheet>
