<?xml version="1.0" encoding="ISO-8859-1"?>
<!-- Guilherme Teixeira, n 5082 - MICEI 2001/2002 - Processamento Estruturado de Docs - Univ. Minho 2001 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" version="1.0" encoding="ISO-8859-1" indent="yes"/>
	<!-- Templates iniciais -->
	<xsl:template match="relatorio">
		<html>
			<body>
				<font face="Verdana" size="2">
					<a name="inicio"/>
					<xsl:apply-templates select="identificacao"/>
					<hr/>
					<xsl:apply-templates select="abertura"/>
					<hr/>
					<xsl:apply-templates select="corpo"/>
					<hr/>
					<xsl:apply-templates select="fecho"/>
					<hr/>
				</font>
			</body>
		</html>
	</xsl:template>
	<!-- Primeira pgina: Identificao do trabalho  -->
	<xsl:template match="identificacao">
		<head>
			<title>
				<xsl:value-of select="titulo"/>
			</title>
		</head>
		<h2>
			<xsl:value-of select="titulo"/>
		</h2>
		<h3>
			<xsl:value-of select="subtitulo"/>
		</h3>
		<hr/>
		<xsl:apply-templates select="autores/autor"/>
		<xsl:apply-templates select="orientadores/orientador"/>
		<br/>
		<xsl:apply-templates select="instituicao"/>
		<br/>
		<i>
			<xsl:value-of select="data"/>
		</i>
		<xsl:call-template name="std_space"/>
		<xsl:call-template name="menu"/>
		<hr/>
		<small>
			<center>
				<xsl:value-of select="copyright"/>
			</center>
		</small>
	</xsl:template>
	<xsl:template match="autor">
		<h4>Autores</h4>
		<xsl:call-template name="EntidadeStyle"/>
	</xsl:template>
	<xsl:template match="orientador">
		<h4>Orientadores</h4>
		<xsl:call-template name="EntidadeStyle"/>
	</xsl:template>
	<xsl:template match="instituicao">
		<xsl:value-of select="nome"/>
		<br/>
		<xsl:value-of select="sobrenome"/>
		<br/>
		<xsl:variable name="link" select="homepage"/>
		<a href="{$link}">
			<xsl:value-of select="homepage"/>
		</a>
		<br/>
	</xsl:template>
	
	<!-- Abertura do relatrio  -->
	
	<xsl:template match="abertura">
		<font size="2">
			<a name="abertura"/>
			<xsl:call-template name="std_space"/>
		<i>
			<b>Dedicatria</b>
				<br/>
			<xsl:apply-templates select="dedicatoria/paragrafo"/>
				<p/>
			<b>Agradecimentos</b>
				<br/>
			<xsl:apply-templates select="agradecimentos/paragrafo"/>
		</i>
		</font>
			<p/>
		<xsl:call-template name="menu"/>
		<xsl:call-template name="std_space"/>
		<a name="prologo"/>
		<h3>Prlogo</h3>
		<p/>
		<xsl:apply-templates select="prologo/paragrafo"/>
			<p/>
			<p/>
		<h3>Resumo</h3>
			<p/>
		<xsl:apply-templates select="resumo/paragrafo"/>
			<p/>
			<p/>
		<h3>Abstract</h3>
			<p/>
		<xsl:apply-templates select="abstract/paragrafo"/>
			<br/>
			<br/>
		<xsl:call-template name="menu"/>
		<xsl:call-template name="std_space"/>
	</xsl:template>
	
	<!-- Corpo do relatrio  -->
	
	<xsl:template match="corpo">
		<a name="indice"/>
		<h3>ndice de Contedos</h3>
		<xsl:apply-templates select="seccao" mode="indice"/>
		<br/>
		<br/>
		<br/>
		<xsl:call-template name="menu"/>
		<hr/>
		<xsl:apply-templates/>
	</xsl:template>
	
	<!-- Gerao ndice de contedos -->
	
	<xsl:template match="seccao" mode="indice">
		<b>
		<a href="#{generate-id()}">
			<xsl:number level="multiple"/>
			<xsl:text>.  </xsl:text>
			<xsl:value-of select="titulo"/>
		</a>
		</b>
		<br/><br/>
		<xsl:apply-templates mode="indice"/>
	</xsl:template>

	<!-- retirar contedo das seces -->
	<xsl:template match="text()" mode="indice"/>

	<!-- Gerao do contedo das seces -->

	<xsl:template match="seccao">
		<xsl:call-template name="std_space"/>
		<h3>
			<a name="{generate-id()}">
				<xsl:number level="multiple"/>. </a>
			<xsl:value-of select="titulo"/>
		</h3>
		<xsl:call-template name="menu"/>
		<p/>
		<xsl:apply-templates/>
		<br/>
	</xsl:template>

	<!-- Limpar os ttulos repetido -->
	<xsl:template match="seccao/titulo"/>
	
	<!-- Gerao das seces finais -->

	<xsl:template match="fecho">
		<font size="2">
			<a name="fecho"/>
			<xsl:call-template name="std_space"/>
			<h3>Eplogo</h3>
				<br/>
			<xsl:apply-templates select="epilogo/paragrafo"/>
				<p/>
		</font>
			<p/>
		<xsl:call-template name="menu"/>
		<xsl:call-template name="std_space"/>
		<a name="glossario"/>
		<h3>Glossrio</h3>
		<p/>
		<xsl:apply-templates select="glossario"/>
		<xsl:call-template name="std_space"/>
		<xsl:call-template name="menu"/>
		<xsl:call-template name="std_space"/>
		<a name="bibliografia"/>
		<h3>Bibliografia</h3>
		<p/>
		<xsl:apply-templates select="bibliografia"/>
		<xsl:call-template name="std_space"/>
		<xsl:call-template name="menu"/>
		<xsl:call-template name="std_space"/>
	</xsl:template>

	<!-- Glossrio -->	
	
	<xsl:template match="glossario">
			<xsl:apply-templates select="itemglo">
			<xsl:sort select="nome"/>
			</xsl:apply-templates>
	</xsl:template>
	
	<xsl:template match="itemglo">
	<br/>
	<b>
	<a name="{nome}"/>
	<xsl:value-of select="nome"/>
	<xsl:text>: </xsl:text>
	</b>
	<xsl:value-of select="descricao"/>
	<br/>
	</xsl:template>
	<!-- Bibliografia -->	
	
	<xsl:template match="bibliografia">
		<xsl:apply-templates select="itembib"/>
	</xsl:template>
	
	<xsl:template match="itembib">
	<br/>
	<a name="{@idbib}"><b>[<xsl:value-of select="@idbib"/>]</b></a>
		<xsl:text> - </xsl:text>
			<xsl:apply-templates select="autores"/>
			<xsl:text> , </xsl:text>
			<i><xsl:value-of select="titulo"/></i>
		<xsl:if test="editora">
			<xsl:text> , </xsl:text>
			<xsl:value-of select="editora/nome"/>
		</xsl:if>
		<xsl:if test="edicao">
			<xsl:text> , </xsl:text>
			<xsl:value-of select="edicao"/><xsl:text> edio </xsl:text>
		</xsl:if>
		<xsl:if test="instituicao">
			<xsl:text> , </xsl:text>
			<xsl:value-of select="instituicao"/>
		</xsl:if>
		<xsl:if test="morada">
			<xsl:text> , </xsl:text>
			<xsl:value-of select="morada"/>
		</xsl:if>
		<xsl:if test="data">
			<xsl:text> , </xsl:text>
			<xsl:value-of select="data"/>
		</xsl:if>
		<xsl:if test="paginas">
			<xsl:text> , pg. </xsl:text>
			<xsl:value-of select="paginas"/>
		</xsl:if>
		<xsl:if test="web">
			<xsl:text> , </xsl:text>
		<xsl:variable name="link" select="web/url"/>
			<a href="{$link}">
				<xsl:value-of select="web/nome"/>
			</a>
		</xsl:if>
		<xsl:if test="isbn">
			<xsl:text> , </xsl:text>
			<xsl:value-of select="isbn"/>
		</xsl:if>
		<br/>
	</xsl:template>
	
	<xsl:template match="autores">
		<xsl:if test="autor/sobrenome">
			<xsl:value-of select="autor/sobrenome"/>
		<xsl:text>, </xsl:text>
		</xsl:if>
		<xsl:value-of select="autor/nome"/>
	</xsl:template>
	
	<!-- Pargrafo  -->
	
	<xsl:template match="paragrafo">
		<p/>
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="bold">
		<b>
			<xsl:value-of select="."/>
		</b>
	</xsl:template>
	<xsl:template match="italico">
		<i>
			<xsl:value-of select="."/>
		</i>
	</xsl:template>
	<xsl:template match="figura">
		<center>
			<xsl:variable name="nome" select="nome"/>
			<xsl:variable name="link" select="url"/>
			<img src="{$link}" alt="{$nome}" border="0" title="{$nome}"/>
			<br/>
			<br/>
			<small>
				<xsl:value-of select="descricao"/>
			</small>
		</center>
	</xsl:template>

	<xsl:template match="codigo">
		<table width="80%" cellspacing="0" cellpadding="0" border="1" align="center">
			<td align="left" bgcolor="#F0F0F0">
					<pre>
					<xsl:apply-templates/>
					</pre>
			</td>
		</table>
	</xsl:template>

	<xsl:template match="refbib">
		<xsl:variable name="bib" select="."/>
		[<a href="#{text()}">
			<xsl:apply-templates/>
		</a>]	
	</xsl:template>

	<xsl:template match="refglo">
		<a href="#{text()}">
		<xsl:apply-templates/>
		</a>	
	</xsl:template>

	<xsl:template match="link">
		<xsl:variable name="link" select="url"/>
			<a href="{$link}">
				<xsl:value-of select="nome"/>
			</a>
	</xsl:template>
	
	<!-- Templates invocadas por nome ****************************************************************************************** -->
	
	<xsl:template name="std_space">
<br/>
<br/>
<br/>
<br/>
<br/>
<br/>
	</xsl:template>
	<xsl:template name="EntidadeStyle">
		<xsl:value-of select="nome"/>
		<xsl:text/>
		<xsl:value-of select="sobrenome"/>
		<br/>
		<small>
			<xsl:variable name="email" select="email"/>
			<a href="mailto:{$email}">
				<xsl:value-of select="email"/>
			</a>
			<xsl:text>  -  </xsl:text>
			<xsl:variable name="link" select="homepage"/>
			<a href="{$link}">
				<xsl:value-of select="homepage"/>
			</a>
		</small>
		<br/>
	</xsl:template>
	<xsl:template name="menu">
		<font size="1">|
	<a href="#inicio">nicio</a>|
	<a href="#abertura">Abertura</a>|
	<a href="#prologo">Prlogo</a>|
	<a href="#indice">ndice</a>|
	<a href="#fecho">Fecho</a>|
	<a href="#glossario">Glossrio</a>|
	<a href="#bibliografia">Bibliografia</a>|
	</font>
	</xsl:template>
</xsl:stylesheet>
