<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" >
<xsl:output indent="yes" method="html" encoding="iso-8859-1" omit-xml-declaration="yes"/>

<xsl:template match="/Jornal"> 
	<html>
		 <body>
			<font face="Verdana" size="2">
			<a name="inicio"/>
	    			<xsl:apply-templates select="cabecalho" />
				<xsl:apply-templates select="corpo" />	    			
				<xsl:apply-templates select="corpo/seccao" /> 
				<xsl:apply-templates select="fecho" /> 
			  <hr /> 
	  		</font>
		  </body>
	  </html>
</xsl:template> 

<!--  Cabeçalho do Jornal    --> 
<xsl:template match="cabecalho">
	<h1>
		<a name="cabecalho"/>
		<xsl:value-of select="nome"/>
	</h1>
		<p><i><xsl:value-of select="data"/></i></p>	
		<p><i><xsl:value-of select="time"/></i></p>	
		<xsl:apply-templates select="directores/director"/>
</xsl:template> 

<xsl:template match="corpo">
	<hr>
		<h2> <a name="ind-geral">Noticias</a> </h2>	
		<a name="destaques"/>
		<h3><a name="ind-geral">Destaques</a></h3>
		 <xsl:apply-templates mode="ind-geral" select="/Jornal/corpo/destaques" /> 
		 <xsl:call-template name="space"/>
		<h2>
			<xsl:call-template name="space"/>
			<a name="seccoes"/>
			<h3><a name="ind-geral">Secções</a></h3>
			<xsl:apply-templates mode="ind-geral" select="/Jornal/corpo/seccao"/> 
			<hr/>
		</h2>
	</hr>
</xsl:template>

	<!-- Geração do fecho do Jornal -->
	<xsl:template match="fecho">
		<font size="1">
			<a name="fecho"/>
			<xsl:call-template name="space"/>
			Direcção Editorial:
			<br/>
			<xsl:apply-templates select="redaccao/directores/director"/>
			<xsl:value-of select="redaccao/copyright"/><br/>
			<xsl:variable name="link" select="url"/>
			<a href="{$link}">
				<xsl:value-of select="redaccao/url"/>
			</a>
		</font>
	</xsl:template>


<!-- Geração do índice-->
	<!-- nome da seccão e  titulos das secções-->
	<xsl:template match="seccao" mode="ind-geral">
		<a href="#{generate-id()}">
			<h3>
				<xsl:call-template name="space"/>
				<xsl:value-of select="nome"/>
			</h3>
		</a>
		<xsl:apply-templates mode="ind-geral" select="artigo"/>
	</xsl:template>
	
	<!-- indice dos titulos e resumos dos destaques -->
	<xsl:template match="destaques" mode="ind-geral">
		<a href="#{generate-id(texto)}">
			<h5>
				<xsl:call-template name="space"/>
				<li/><xsl:value-of select="titulo"/>
			</h5>
		</a>
		<h6><xsl:value-of select="subtitulo"></xsl:value-of></h6>
		<h6><xsl:value-of select="data"></xsl:value-of></h6>
		<h6><xsl:value-of select="time"></xsl:value-of></h6>
			<xsl:apply-templates select="resumo"/> 
		<p>
	 		<xsl:apply-templates select="figuras"/>
	 		<xsl:apply-templates select="autores/autor"/>
		</p>
	</xsl:template>	
	
	<!-- retirar conteúdo das secções -->
	<xsl:template match="text()" mode="ind-geral"/>
	
	<!-- indice dos titulos dos artigos -->
	<xsl:template match="artigo" mode="ind-geral">
			<a href="#{generate-id()}">
				<h5>
					<li/><xsl:value-of select="titulo"/>
				</h5>
			</a>
	</xsl:template>
	
	<xsl:template match="seccao">
		<xsl:call-template name="space"/>
		<h2>
			<a name="{generate-id()}">
				<xsl:value-of select="nome"/>
			</a>
		</h2>
		<xsl:apply-templates select="artigo"/> 
		<br/>
	</xsl:template>
	
<!-- acrescentei isto para refartigodestaques
	<xsl:template match="destaques">
		<xsl:call-template name="space"/>
		<h2>
			<a name="{generate-id()}">
				<xsl:value-of select="titulo"/>
			</a>
		</h2>
			<h6><xsl:value-of select="subtitulo"></xsl:value-of></h6>
			<h6><xsl:value-of select="data"></xsl:value-of></h6>
			<h6><xsl:value-of select="time"></xsl:value-of></h6>
		<small>
			 <xsl:value-of select="resumo"/> 
		</small>
	 	<p>
	 		<xsl:apply-templates select="figuras/figura"/>
	 		<xsl:apply-templates select="autores/autor"/>
		</p>
		<br/>
	</xsl:template>
acrescentei isto para refartigodestaques-->

	<!-- leitura dos resumos-->
	<xsl:template match="resumo">
		<xsl:apply-templates/>
	</xsl:template> 

	
	<!-- Leitura dos artigos-->
	<xsl:template match="artigo">
		<h3>
			<xsl:call-template name="space"/>
			<a name="{generate-id()}">
				<xsl:value-of select="titulo"/>
			</a>
		</h3>
		<h6><xsl:value-of select="subtitulo"></xsl:value-of></h6>
		<h6><xsl:value-of select="data"></xsl:value-of></h6>
		<h6><xsl:value-of select="time"></xsl:value-of></h6>
		<small>
			 <xsl:apply-templates select="resumo"/> 
		</small>
	 	<p>
	 		<xsl:apply-templates select="figuras"/>
			<xsl:apply-templates select="corpo/paragrafo"/>
		</p>
		<xsl:apply-templates select="autores/autor"/>
		<address>
		<center>
		<hr/>
		 <table width="100%">
			<tbody>
				<tr>
					<xsl:if test="count(preceding-sibling::artigo) >= 0"> 
						<td align="left">  <font size="1">| <a href="#{generate-id(preceding-sibling::artigo[1])}">Artigo Anterior</a> </font>|</td>
					</xsl:if> 
					<td align="center"><xsl:call-template name="menu"/></td>
					<xsl:if test="count(following-sibling::artigo) >= 0">
						<td align="right"> <font size="1">|  <a href="#{generate-id(following-sibling::artigo[1])}">Artigo Seguinte</a></font>|</td>
					</xsl:if> 
				</tr>
			</tbody>
		</table>
		</center>
		<hr/>
		</address>
	</xsl:template>

	<!-- ###  Leitura dos directores  e dos  autores  ### -->
	<xsl:template match="director|autor">
		<xsl:call-template name="Pessoa"/>
	</xsl:template>

	<!-- ### Leitura da informação da pessoa ####-->
	<xsl:template name="Pessoa">
		<xsl:value-of select="nome"/>
		<xsl:text>  </xsl:text>
		<xsl:value-of select="sobrenome"/>
		<br/>
		<small>
			<xsl:variable name="email" select="email"/>
			<a href="mailto:{$email}">
				<xsl:value-of select="email"/>
			</a>
			<xsl:variable name="link" select="homepage"/>
			<a href="{$link}">
				<xsl:value-of select="homepage"/>
			</a>
		</small>
		<br/>
		<small>
			<center>
				<xsl:value-of select="copyright"/>
			</center>
		</small>
		<br/>
	</xsl:template>
	
	
	<xsl:template match="paragrafo">
		<p/>
			<xsl:apply-templates/>			
	</xsl:template>

	<xsl:template match="figuras/figura">
		<center>
			<img src="{@path}" alt=""/>
			<xsl:value-of select="legenda"/>	
		</center>
	</xsl:template> 
	
	<xsl:template match="bold">
		<b>
			<xsl:value-of select="."/>
		</b>
	</xsl:template>
	
	<xsl:template match="italico">
		<i>
			<xsl:value-of select="."/>
		</i>
	</xsl:template>

	<xsl:template match="iref">
		<xsl:variable name="bib" select="."/>
		[<a href="#{text()}">
			<xsl:apply-templates/>
		</a>]	
	</xsl:template>

	<xsl:template match="RefBib">
		<xsl:variable name="bib" select="."/>
		[<a href="#{text()}">
			<xsl:apply-templates/>
		</a>]	
	</xsl:template>

 <!-- ### barra para saltar entre items ### -->
<xsl:template name="menu">
	<font size="1">|
		<a href="#inicio">Início</a>|
		<a href="#destaques">Destaques</a>|
		<a href="#seccoes">Secções</a>|
		<a href="#fecho">Fecho</a>|
	</font>
</xsl:template>

 <!-- ### espaçamento  ### -->
<xsl:template name="space">
	<br/>
	<br/>
</xsl:template>


</xsl:stylesheet>
