<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output indent="yes" method="html" encoding="iso-8859-1" omit-xml-declaration="yes"/>
	<xsl:key name="refArtigo" match="/Jornal/corpo/seccao/artigo" use="@id"/>
	
	<!--         Raiz do Jornal  -->
	<xsl:template match="/Jornal">
		<html>
			<body>
				<font face="Verdana" size="2">
					<a name="inicio"/>
					<xsl:apply-templates select="cabecalho"/>
					<xsl:apply-templates select="corpo"/>
					<xsl:apply-templates select="corpo/seccao"/>
					<xsl:apply-templates select="fecho"/>
					<hr/>
				</font>
			</body>
		</html>
	</xsl:template>
	
	<!--   Cabeçalho do Jornal   -->
	<xsl:template match="cabecalho">
		<a name="cabecalho"/>
		<xsl:if test="figuras">
			<table width="100%">
				<tbody>
					<tr>
						<td align="center"><b> <xsl:text>Uma Cidade Perto de Si</xsl:text></b></td>
						<td><xsl:apply-templates select="figuras"/></td>
					</tr>
				</tbody>
			</table>
		</xsl:if>
		<table width="100%">
			<tbody>
				<tr bgcolor="#D0D0D0">
					<th>
						<h1>
							<font color="blue ">
								<xsl:value-of select="nome"/>
							</font>
						</h1>
					</th>
				</tr>
				<tr align="right">
					<th>
						<h6>
							<i>
								<xsl:value-of select="data "/>
								<xsl:text>    </xsl:text>
								<b>
									<xsl:value-of select="time"/>
								</b>
							</i>
						</h6>
					</th>
				</tr>
			</tbody>
		</table>
		<xsl:apply-templates select="directores/director"/>
	</xsl:template>
	
	<!--  Corpo do Jornal  -->
	<xsl:template match="corpo">
		<hr>
			<h2>
				<font color="blue ">
					<a name="ind-geral">Noticias</a>
				</font>
			</h2>
			<a name="destaques"/>
			<h4>
				<table width="100%">
					<tbody>
						<tr align="justify" bgcolor="#D0D0D0">
							<th>
								<a name="ind-geral">Destaques</a>
							</th>
						</tr>
					</tbody>
				</table>
			</h4>
			<xsl:apply-templates mode="ind-destaque" select="/Jornal/corpo/seccao"/>
			<xsl:call-template name="space"/>
			<xsl:call-template name="space"/>
			<hr/>
			<a name="seccoes"/>
			<table width="100%">
				<tbody>
					<tr align="justify" bgcolor="#D0D0D0" >
						<th> 
							<h3><a name="ind-geral">Secções</a></h3>
						</th>
					</tr>
				</tbody>
			</table>
			<xsl:apply-templates mode="ind-geral" select="/Jornal/corpo/seccao"/>
		</hr>
		<hr/>
	</xsl:template>
	
	<!--  Fecho do Jornal  -->
	<xsl:template match="fecho">
		<font size="1">
			<a name="fecho"/>
			<xsl:call-template name="space"/>
			Direcção Editorial:<br/>
			<xsl:apply-templates select="redaccao/directores/director"/>
			<xsl:value-of select="redaccao/copyright"/>
			<br/>
			<xsl:apply-templates  select="redaccao/url "/>
		</font>
		<xsl:if test="figuras">
		<br/>
			<table width="100%">
				<tbody>
					<tr>
						<td align="center"> <b><xsl:text>É bom viver Aqui</xsl:text></b></td>
						<td><xsl:apply-templates select="figuras"/></td>
					</tr>
				</tbody>
			</table>
		</xsl:if>
	</xsl:template>
	
	<!--#############  Geração do índice ############# -->
	<!--   nome da seccão e  titulos das secções  -->
	<xsl:template match="seccao" mode="ind-geral">
		<a href="#{generate-id()}">
			<h3>
				<xsl:call-template name="space"/>
				<font color="blue ">
					<xsl:value-of select="nome"/>
				</font>
			</h3>
		</a>
		<xsl:apply-templates mode="ind-geral" select="artigo"/>
		<xsl:if test="seccao">
			<xsl:apply-templates mode="ind-subseccoes" select="seccao"/>
		</xsl:if>
	</xsl:template>

	<!--   nome da subseccão e  titulos das subsecções  -->
	<xsl:template match="seccao" mode="ind-subseccoes">
		<a href="#{generate-id()}">
			<h3>
				<font color="blue">
					<xsl:text> Subsecção </xsl:text>
					<xsl:value-of select="nome"/>
				</font>
			</h3>
		</a>
		<xsl:apply-templates mode="ind-geral" select="artigo"/>
	</xsl:template>
	
	<!--   titulos dos Destaques  -->
	<xsl:template match="seccao" mode="ind-destaque">
		<a href="#{generate-id()}">
			<h4>
				<xsl:call-template name="space"/>
				<xsl:value-of select="artigo[1]/titulo"/>
			</h4>
		</a>
		<table>
			<tbody>
				<tr>
					<td align="left">
						<small>
							<xsl:apply-templates select="artigo[1]/resumo"/>
						</small>
					</td>
					<td align="right">
						<xsl:apply-templates select="artigo[1]/figuras"/>
					</td>
				</tr>
			</tbody>
		</table>
	</xsl:template>
	
	<!--   Titulos dos artigos  -->
	<xsl:template match="artigo" mode="ind-geral">
		<a href="#{generate-id()}">
			<h5>
				<li/>
				<xsl:value-of select="titulo"/>
			</h5>
		</a>
	</xsl:template>
	
	<!--  Conteúdo das secções  -->
	<xsl:template match="seccao">
		<xsl:call-template name="space"/>
		<h2>
			<a name="{generate-id()}">
				<font color=" blue">
					<xsl:value-of select="nome"/>
				</font>
			</a>
		</h2>
		<xsl:apply-templates select="artigo"/>
		<xsl:if test="seccao">
			<xsl:apply-templates mode="subseccoes" select="seccao"/>
		</xsl:if>
		<br/>
	</xsl:template>
	
	<!--  Conteúdo das subsecções  -->
	<xsl:template match="seccao" mode="subseccoes">
		<h3>
			<a name="{generate-id()}">
				<font color="blue">
					<xsl:text> Subsecção </xsl:text>
					<xsl:value-of select=" nome"/>
				</font>
			</a>
		</h3>
		<xsl:apply-templates select="artigo"/>
	</xsl:template>
	
	<!--  leitura dos resumos  -->
	<xsl:template match="resumo">
		<xsl:apply-templates select="paragrafo"/>
	</xsl:template>
	
	
	<!--  leitura do corpo do artigo -->
	<xsl:template match="corpoArtigo">
		<br/>
		<xsl:apply-templates />
	</xsl:template>
	
	
	<!--    Leitura dos artigos   -->
	<xsl:template match="artigo">
		<h3>
			<xsl:call-template name="space"/>
			<a name="{generate-id()}">
				<xsl:value-of select="titulo"/>
			</a>
		</h3>
		<h6>
			<xsl:value-of select="subtitulo"/>
		</h6>
		<h6>
			<xsl:value-of select="data"/>
			<xsl:if test="time">
				<xsl:text> - </xsl:text>
				<xsl:value-of select="time"/>
			</xsl:if>
		</h6>
		<table>
			<tbody>
				<tr>
					<td align="justify">
						<small>
							<xsl:apply-templates select="resumo"/>
						</small>
					</td>
				</tr>
			</tbody>
		</table>
		<p>
			<xsl:apply-templates select="figuras"/>
			<xsl:apply-templates select="corpoArtigo"/>
		</p>
		<xsl:if test="autores/autor">
			<small>
				<xsl:text> Por: </xsl:text>
				<br/>
				<xsl:apply-templates select="autores/autor"/>
			</small>
		</xsl:if>
		<xsl:if test="intRef">
			<xsl:call-template name="space"/>
			<xsl:apply-templates select="intRef"/>
		</xsl:if>
		<address>
			<center>
				<hr/>
				<table width="100%">
					<tbody>
						<tr>
							<xsl:if test="count(preceding-sibling::artigo) >= 0">
								<td align="left">
									<font size="1">| <a href="#{generate-id(preceding-sibling::artigo[1])}">Artigo Anterior</a>
									</font>|</td>
							</xsl:if>
							<td align="center">
								<xsl:call-template name="menu"/>
							</td>
							<xsl:if test="count(following-sibling::artigo) >= 0">
								<td align="right">
									<font size="1">|  <a href="#{generate-id(following-sibling::artigo[1])}">Artigo Seguinte</a>
									</font>|</td>
							</xsl:if>
						</tr>
					</tbody>
				</table>
			</center>
			<hr/>
		</address>
	</xsl:template>
	
	<!--    template para as referencias internas   -->
	<xsl:template match="intRef">
		<xsl:variable name="ref" select="@destino"/>
		<small>Artigo Relacionado: </small>
		<a href="#{generate-id(/Jornal/corpo/seccao/artigo[@id=$ref])}">
			<small>
				<xsl:value-of select="key('refArtigo',@destino)/titulo"/>
			</small>
			<xsl:call-template name="space"/>
		</a>
	</xsl:template>
	
	<!--   Leitura dos directores  e dos  autores   -->
	<xsl:template match="director|autor">
		<xsl:call-template name="Pessoa"/>
	</xsl:template>
	
	<!--   Leitura da informação da pessoa   -->
	<xsl:template name="Pessoa">
		<xsl:value-of select="nome"/>
		<xsl:if test="sobrenome">
			<xsl:text>  </xsl:text>
			<xsl:value-of select="sobrenome"/>
		</xsl:if>
		<br/>
		<small>
			<xsl:variable name="email" select="email"/>
			<a href="mailto:{$email}">
				<xsl:value-of select="email"/>
			</a>
			<xsl:if test="url">
				<xsl:apply-templates select="url"/>
			</xsl:if>
		</small>
		<xsl:call-template name="space"/>
		<small>
			<center>
				<xsl:value-of select="copyright"/>
			</center>
		</small>
		<br/>
	</xsl:template>
	
	<!--   Leitura dos parágrafos   -->
	<xsl:template match="paragrafo">
		<p/> 
		<xsl:apply-templates/>
	</xsl:template>
	
	<!--   Leitura das figuras   -->
	<xsl:template match="figuras">
		<xsl:choose>
			<xsl:when test="figura/@alinha = 'direita'">
				<div align="right">
					<img src="{figura/@path}" alt=""/>
					<br/>
					<small>
						<xsl:value-of select="legenda"/>
					</small>
				</div>
			</xsl:when>
			<xsl:when test="figura/@alinha = 'centro'">
				<center>
					<img src="{figura/@path}" alt=""/>
				</center>
				<br/>
				<center>
					<small>
						<xsl:value-of select="legenda"/>
					</small>
				</center>
			</xsl:when>
			<xsl:when test="figura/@alinha = 'esquerda'">
				<div align="left">
					<img src="{figura/@path}" alt=""/>
					<br/>
					<small>
						<xsl:value-of select="legenda"/>
					</small>
				</div>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<!--  leitura dos subtitulos dos subartigos   -->
	<xsl:template match="subtitulo">
		<p/>
			<b>
				<xsl:value-of select="."/>
			</b>
		<p/>
	</xsl:template>
	
	<!--   tratamento do formato bold   -->
	<xsl:template match="bold">
		<b>
			<xsl:value-of select="."/>
		</b>
	</xsl:template>
	
	<!--   tratamento do formato itálico   -->
	<xsl:template match="italico">
		<i>
			<xsl:value-of select="."/>
		</i>
	</xsl:template>
	
	<!--   leitura dos url's   -->
	<xsl:template match="url">
		<xsl:variable name="link" select="url"/>
		<a href="{$link}">
			<xsl:value-of select="."/>
			<br/>
		</a>		
	</xsl:template>

	<!--   barra para saltar entre items   -->
	<xsl:template name="menu">
		<font size="1">|
			<a href="#inicio">Início</a>|
			<a href="#destaques">Destaques</a>|
			<a href="#seccoes">Secções</a>|
			<a href="#fecho">Fecho</a>|
		</font>
	</xsl:template>
	
	<!--   espaçamento    -->
	<xsl:template name="space">
		<br/>
		<br/>
	</xsl:template>
	
</xsl:stylesheet>
