<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="ISO-8859-1" indent="yes" method="html"/>
  <xsl:param name="num-ficha">1</xsl:param>
  
  <xsl:template match="/">
      <html>
        <head>
          <link rel="stylesheet" href="fichas.css" type="text/css"/>
        </head>
        <body>
          <xsl:call-template name="driver"/>
          <xsl:apply-templates select="AulaPrtica/corpo/exerccio"/>
        </body>
      </html>
    
  </xsl:template>
  
  <xsl:template name="driver">
    <table width="100%">
      <tbody>
        <tr bgcolor="#FFCCFF">
          <td align="left">
            <div class="header">
              <a name="driver">Ficha N<xsl:value-of select="$num-ficha"/>
              </a>
            </div>
          </td>
          <td align="center">
            <div class="header">
              <xsl:value-of select="AulaPrtica/meta/disciplina"/>
            </div>
          </td>
          <td align="right">
            <div class="header">
              <xsl:apply-templates select="AulaPrtica/meta/datas"/>
            </div>
          </td>
        </tr>
      </tbody>
    </table>
    <hr/>
    <table>
      <tbody>
        <tr>
          <td valign="top">
            <h4>Objectivos:</h4>
          </td>
          <td/>
        </tr>
        <tr>
          <td/>
          <td>
            <xsl:apply-templates select="AulaPrtica/meta/objectivos"/>
          </td>
        </tr>
        <xsl:if test="AulaPrtica/meta/recursos">
          <tr>
            <td valign="top">
              <h4>Recursos:</h4>
            </td>
            <td/>
          </tr>
          <tr>
            <td/>
            <td>
              <div class="para"> Recursos disponveis para a realizao da ficha:</div>
              <br/>
              <xsl:apply-templates select="AulaPrtica/meta/recursos"/>
            </td>
          </tr>
        </xsl:if>
        <xsl:if test="AulaPrtica/corpo/introduo">
          <tr>
            <td valign="top">
              <h4>Introduo:</h4>
            </td>
            <td/>
          </tr>
          <tr>
            <td/>
            <td>
              <xsl:apply-templates select="AulaPrtica/corpo/introduo"/>
            </td>
          </tr>
        </xsl:if>
        <tr>
          <td>
            <h4>
              <a name="ind-ex">Exerccios:</a>
            </h4>
          </td>
          <td> </td>
        </tr>
        <tr>
          <td/>
          <td>
            <ol>
              <xsl:for-each select="AulaPrtica/corpo/exerccio">
                <a name="ind-ex"/>
                <li>
                  <a href="#e{count(preceding-sibling::exerccio)+1}">
                    <xsl:value-of select="ttulo"/>
                  </a>
                </li>
              </xsl:for-each>
            </ol>
          </td>
        </tr>
      </tbody>
    </table>
    <hr/>
    <center>
      <div class="footer">
        <a href="../">Voltar ao ndice de fichas</a> <br/>
      </div>
    </center>
    <address>by <a href="http://www.di.uminho.pt/~jcr">jcr</a></address>
    <hr/>
  </xsl:template>
  
  <xsl:template match="introduo">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="datas">
    <center>
      <xsl:for-each select="data">
        <xsl:value-of select="."/> (<xsl:value-of select="@tipo"/>)
        <br/>
      </xsl:for-each>
    </center>
  </xsl:template>

  <xsl:template match="recursos">
    <ul>
      <xsl:apply-templates/>
    </ul>
  </xsl:template>

  <xsl:template match="documento">
    <li>
      <a href="{@url}">
        <xsl:value-of select="."/>
      </a>
    </li>
  </xsl:template>

  <xsl:template match="exerccio">
      <h3>Exerccio N<xsl:value-of select="count(preceding-sibling::exerccio)+1"/>: <xsl:value-of select="ttulo"/></h3>
      <a name="e{count(preceding-sibling::exerccio)+1}"/>
      <xsl:apply-templates select="enunciado"/>
      <hr/>
      <center>
        <div class="footer">
          <a href="#ind-ex">Voltar ao ndice de exerccios</a>
        </div>
      </center>  
    <hr/>
  </xsl:template>
  
  <xsl:template match="enunciado">
    <xsl:apply-templates/>
  </xsl:template>
  
  <xsl:template match="imagem">
    <div class="img">
     <center>
      <xsl:choose>
        <xsl:when test="grafico/@width">
          <img src="{grafico/@path}" width="{grafico/@width}"/>
        </xsl:when>
        <xsl:otherwise>
          <img src="{grafico/@path}"/>
        </xsl:otherwise>
      </xsl:choose>    
      <p><b>Fig.<xsl:value-of select="count(preceding::imagem)+1"/>: <xsl:value-of select="legenda"/></b></p>
      </center>
    </div>
  </xsl:template>
  
  <xsl:template match="para">
    <br>
      <div class="para">
        <xsl:apply-templates/>
      </div>
    </br>
  </xsl:template>
  <xsl:template match="lista">
    <ul>
      <xsl:apply-templates/>
    </ul>
  </xsl:template>

  <xsl:template match="listan">
    <ol>
      <xsl:apply-templates/>
    </ol>
  </xsl:template>

  <xsl:template match="listad">
    <dl>
      <xsl:apply-templates/>
    </dl>
  </xsl:template>

  <xsl:template match="listan/item|lista/item">
    <li>
      <xsl:apply-templates/>
    </li>
  </xsl:template>

  <xsl:template match="termo">
    <dt>
      <xsl:apply-templates/>
    </dt>
  </xsl:template>

  <xsl:template match="descricao">
    <dd>
      <xsl:apply-templates/>
    </dd>
  </xsl:template>

  <xsl:template match="item">
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="realce[@tipo='emph']">
    <i>
      <xsl:apply-templates/>
    </i>
  </xsl:template>

  <xsl:template match="realce">
    <b>
      <xsl:apply-templates/>
    </b>
  </xsl:template>

  <xsl:template match="codigo">
    <pre class="codigo">
      <xsl:apply-templates/>
    </pre>
  </xsl:template>
  <xsl:template match="alneas">
    <ol class="a">
      <xsl:apply-templates/>
    </ol>
  </xsl:template>
  <xsl:template match="alnea">
    <li>
      <xsl:apply-templates/>
    </li>
  </xsl:template>
  <xsl:template match="kw">
    <b>
      <xsl:apply-templates/>
    </b>
  </xsl:template>
  <xsl:template match="xref">
    <a href="{@url}">
      <xsl:value-of select="."/>
    </a>
  </xsl:template>

  <xsl:template match="tabela">
    <table border="1">
      <xsl:apply-templates/>
    </table>
  </xsl:template>
  <xsl:template match="linha">
    <tr>
      <xsl:apply-templates/>
    </tr>
  </xsl:template>
  <xsl:template match="celula">
    <td>
      <xsl:apply-templates/>
    </td>
  </xsl:template>
</xsl:stylesheet>
