#version 330

uniform samplerCube texUnit; 

in vec3 normalV;
in vec3 eyeV;
in vec3 posV;

out vec4 outColor;

void main() {

	// normalize vectors
	vec3 n = normalize(normalV);
	vec3 e = normalize(eyeV);

	// compute reflection vector
	vec3 t = reflect(e, n);

    // size of cubemap
	float d = 250;
	
	vec3 i1 = (d - posV) / t;
	vec3 i2 = (-d - posV) / t;

	vec3 furtherst = max(i1,i2);
	float k = min(min(furtherst.x, furtherst.y), furtherst.z);
	vec3 dir = posV + k*t;
	//dir = normalize(dir);
	// if (abs(length(dir)-1) > 0.000001)
	// 	outColor = vec4(1,0,0,0);
	// else
	// 	outColor = vec4(0,1,0,0);
		
	// access cube map texture
	vec3 ref = texture(texUnit, dir).rgb;
	outColor = vec4(ref, 1.0);
}