#version 410

layout(triangles, fractional_even_spacing, ccw) in;

uniform	mat4 projViewModelMatrix;
uniform	mat3 normalMatrix;

uniform float alpha = 0.75;

in vec4 normalTC[];
in vec4 posTC[];

out vec3 normalTE;

void main() {

	vec4 P0 = posTC[0];
	vec4 P1 = posTC[1];
	vec4 P2 = posTC[2];
	vec4 n0 = normalTC[0];
	vec4 n1 = normalTC[1];
	vec4 n2 = normalTC[2];
	
	float u = gl_TessCoord.x;
	float v = gl_TessCoord.y;
	float w = 1 - u - v;
	
	vec4 Puv = P0*w + P1*u + P2*v;
	vec4 Proj0 = Puv - (dot(Puv-P0, n0)) * n0;
	vec4 Proj1 = Puv - (dot(Puv-P1, n1)) * n1;
	vec4 Proj2 = Puv - (dot(Puv-P2, n2)) * n2;
	
	normalTE = normalize(normalMatrix * vec3(n0*w + n1*u + n2*v));
				
	vec4 res =  (1 - alpha) * Puv  + alpha * (Proj0 * w + Proj1 * u + Proj2 * v);
	
	gl_Position = projViewModelMatrix * res;
}

